#ifndef _PACKAGE_H
#define _PACKAGE_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "IndexDir.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define DfltBufferSize 1048576
#define ExtraSize      (512 * 1024)
#define HARDCHECKSUM   9841478
#define HASHKEYLEN     512
#define CHECKSUMLEN    1024
#define CRYPTMETHOD    CIPHERUSERSKEY

#define CRYPT_ALGO_NASCCL   0
#define CRYPT_ALGO_RIJNDAEL 1
#define CRYPT_ALGO_BLOWFISH 2

#define BLOWFISH_KEY_LEN 56
#define RIJNDAEL_KEY_LEN 32

#define ATTRIB_COMPRESSION 0x0001
#define ATTRIB_DATETIME    0x0002
#define ATTRIB_CRCCHECK    0x0004
#define ATTRIB_SAVEPATHS   0x0010
#define ATTRIB_ATTRIBUTES  0x0020

#define ATTRIB_ADDFILES        0x0001 //Add files to the archive, otherwise we will replace the existing archive.
#define ATTRIB_USEALTFILEPACK  0x0002 //Use the contents of the passed lpMyFilePack structure.

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct _MakePackage_Params{
	char *sSrcFolder;
	char *sTarName;
	char *sRawKey;
	int iRawKeyLen;
	int iPkgAttribs;
	int iOptions;
} MKPKGPARAM, *LPMKPKGPARAM;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool BreakPackage(char *SrcName, char *TarFolder, char *RawKey, int RawKeyLen);
bool MakePackage(LPMKPKGPARAM lpMyMkPkgParam);
bool PopGrid(char *SrcName, char *RawKey, int RawKeyLen);

DWORD WINAPI CreateNewDirArchive_Worker_Thread(LPVOID xData);
DWORD WINAPI ViewExisting_Worker_Thread(LPVOID xData);
DWORD WINAPI ExtractEntireArchive_Worker_Thread(LPVOID xData);
DWORD WINAPI CreateFileArchive_Worker_Thread(LPVOID xData);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern DWORD dwPackageProgress;

extern DWORD dwWorker_Thread_ID;
extern HANDLE hWorker_Thread_Handle;

extern FILEPACKAGE AltFilePackage;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
